!Object constantsFor: 'Geos Libraries'!

geosLIB61 'SYSTEM\scep'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

sConnectRsp 8704!
sCommandRsp 8705!
sDisconnectReq 8706!
getState 8707!
sCommandReq 8708!
sConnectReq 8709!
sAbortReq 8710!
sConnectInd 26624!
sDisconnectInd 26625!
sAbortInd 26626!
sCommandInd 26627!
receivingData 26628!
sCommandidInd 26629!
sConnectCnf 26630!
sCommandCnf 26631!
!

!Geos class methodsFor: 'library calls'!

!

Process subclass: #SCEP_Communication
	instanceVariableNames: ''
	classVariableNames: ''!

Gen subclass: #SCEPClient
	instanceVariableNames: ''
	classVariableNames: ''!

!SCEP_Communication comment!
Library scep, file internal/resp/scep.goh! !

!SCEP_Communication class methodsFor: 'library linkage'!

library
	^61!

entry
	^0001!
!

!SCEP_Communication methodsFor: 'Geos instance variables'!

!

!SCEP_Communication methodsFor: 'Geos vardata'!

!

!SCEP_Communication methodsFor: 'Geos messages'!

sConnectRsp: AckOrNackFlag with: mhConnectData
	"@message void MSG_SCEP_S_CONNECT_RSP( const Boolean AckOrNackFlag, MemHandle mhConnectData )"
	^self geosMessage: #[34 0 1 0 4 1 0] with: AckOrNackFlag with: mhConnectData!

sCommandRsp: AckOrNackFlag with: mhCommandRspData
	"@message void MSG_SCEP_S_COMMAND_RSP( const Boolean AckOrNackFlag, MemHandle mhCommandRspData )"
	^self geosMessage: #[34 1 1 0 4 1 0] with: AckOrNackFlag with: mhCommandRspData!

sDisconnectReq: wReasonLength with: mhDIS_req
	"@message void MSG_SCEP_S_DISCONNECT_REQ( const word wReasonLength, MemHandle mhDIS_req )"
	^self geosMessage: #[34 2 1 0 1 1 0] with: wReasonLength with: mhDIS_req!

getState
	"@message SCEP_STATE MSG_SCEP_GET_STATE()"
	^self geosMessage: #[34 3 2 0 1]!

sCommandReq: mhCommandReqData
	"@message void MSG_SCEP_S_COMMAND_REQ( const MemHandle mhCommandReqData )"
	^self geosMessage: #[34 4 1 0 1 0] with: mhCommandReqData!

sConnectReq: mhConnectReqData
	"@message void MSG_SCEP_S_CONNECT_REQ( const MemHandle mhConnectReqData )"
	^self geosMessage: #[34 5 1 0 1 0] with: mhConnectReqData!

sAbortReq: mhAbortReqData
	"@message void MSG_SCEP_S_ABORT_REQ( const MemHandle mhAbortReqData )"
	^self geosMessage: #[34 6 1 0 1 0] with: mhAbortReqData!

!

!SCEPClient comment!
Library scep, file internal/resp/scep.goh! !

!SCEPClient class methodsFor: 'library linkage'!

library
	^61!

entry
	^0000!
!

!SCEPClient methodsFor: 'Geos instance variables'!

!

!SCEPClient methodsFor: 'Geos vardata'!

!

!SCEPClient methodsFor: 'Geos messages'!

sConnectInd: mhConnectData
	"@message void MSG_APP_S_CONNECT_IND( MemHandle mhConnectData )"
	^self geosMessage: #[104 0 1 0 1 0] with: mhConnectData!

sDisconnectInd: wReasonLength with: mhDIS_ind with: ifStatus with: dwBytesRequired
	"@message void MSG_APP_S_DISCONNECT_IND( const word wReasonLength, MemHandle mhDIS_ind, const SCEP_IF_Status ifStatus, const dword dwBytesRequired )"
	^self geosMessage: #[104 1 1 0 1 1 1 2 0] with: wReasonLength with: mhDIS_ind with: ifStatus with: dwBytesRequired!

sAbortInd: mhAbortIndData
	"@message void MSG_APP_S_ABORT_IND( MemHandle mhAbortIndData )"
	^self geosMessage: #[104 2 1 0 1 0] with: mhAbortIndData!

sCommandInd: mhCommandIndData
	"@message void MSG_APP_S_COMMAND_IND( MemHandle mhCommandIndData )"
	^self geosMessage: #[104 3 1 0 1 0] with: mhCommandIndData!

receivingData
	"@message void MSG_APP_RECEIVING_DATA()"
	^self geosMessage: #[104 4 2 0 0]!

sCommandidInd: wCmdID
	"@message void MSG_APP_S_COMMANDID_IND( const word wCmdID )"
	^self geosMessage: #[104 5 1 0 1 0] with: wCmdID!

sConnectCnf: BAckOrNack with: mhConnectCnfData
	"@message void MSG_APP_S_CONNECT_CNF( const Boolean BAckOrNack, MemHandle mhConnectCnfData )"
	^self geosMessage: #[104 6 1 0 4 1 0] with: BAckOrNack with: mhConnectCnfData!

sCommandCnf: BAckOrNack with: mhCommandCnfData
	"@message void MSG_APP_S_COMMAND_CNF( const Boolean BAckOrNack, MemHandle mhCommandCnfData )"
	^self geosMessage: #[104 7 1 0 4 1 0] with: BAckOrNack with: mhCommandCnfData!

!

